/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
	The script prints out a message whenever an object is created or destroyed.
	There are also examples of the new format for bhs.dll hooks.
*/
#include ".\pythoninclude\Python.h"
#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
//#include "loading.h"
#include "module.h"
#include "gmconsolecommands.h"
#include "hooks.h"
#include "plugin.h"
#include "scriptsmanager.h"
#include "jnz_hooks.h"

void Plugin_Load() 
{
	Py_Initialize();
	PyImport_AppendInittab("scriptsdll", &PyInit_scriptsdll);
	PyRun_SimpleString("print('\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n')");
	PyRun_SimpleString("from scriptsdll import *");
	Load_All_Modules();
	PyRun_SimpleString("print('\\n\\n\\n\\n\\n\\n\\n\\n\\n')");
	printf("\n%S\n",Py_GetPath());

	ConsoleCommand::InstallCommands(); //Adds extra Python-related console commands to the FDS

	Load_Hooks();
	AddSerialHook(Hooks::Serial_Hook);
	AddLoadingEHook(Hooks::LoadingE_Hook);
	AddDamageHook(Hooks::Damage_Hook);
	//AddChatEHook(Hooks::Chat_Hook);
	AddPingHook(Hooks::Ping_Hook);
	AddSuicideHook(Hooks::Suicide_Hook);
	AddRadioHook(Hooks::Radio_Hook);
	//AddThinkHook(Hooks::Think_Hook); // The ThinkHook isn't part of released versions of jnz' Hooks.dll (yet)
	AddVersionHook(Hooks::Version_Hook);
	//AddCharacterPurchaseMonHook(Hooks::Purchase_Hook, "OnCharacterPurchase");
	//AddVehiclePurchaseMonHook(Hooks::Purchase_Hook, "OnVehiclePurchase");
	//AddPowerupPurchaseMonHook(Hooks::Purchase_Hook, "OnPowerupPurchase");  // DEBUG CRAP

	ObjectCreateHookStruct *_och = new ObjectCreateHookStruct;
	_och->hook = Hooks::Object_Hook;
	_och->data = 0;
	AddObjectCreateHook(_och); 
	
	ScriptManager::Load();	
}

void Plugin_Unload() 
{
	  Py_Finalize();
	  ScriptManager::Cleanup();
}

/*
extern "C" {


DLLEXPORT void SSGM_Host_Hook(int ID, int Type, const char *Msg) 
{
	Hooks::Host_Hook(ID, Type, Msg);
}

DLLEXPORT void SSGM_Player_Join_Hook(int ID, const char *Nick) 
{
	Hooks::Player_Join_Hook(ID, Nick);
}

DLLEXPORT void SSGM_Player_Leave_Hook(int ID) 
{
	Hooks::Player_Leave_Hook(ID);
}

DLLEXPORT void SSGM_Level_Loaded_Hook() 
{
	//Hooks::Level_Loaded_Hook(); // DEBUG CRAP
}

DLLEXPORT void SSGM_GameOver_Hook() 
{
	//Hooks::GameOver_Hook();
}

DLLEXPORT void SSGM_Console_Output_Hook(const char *Output) 
{
	Hooks::Console_Output_Hook(Output);
}

DLLEXPORT bool SSGM_DDE_Hook(const char *DDE) 
{
	Hooks::DDE_Hook(DDE);
	return true;
} // DEBUG CRAP
}*/


